qui {
clear all
noisily {
				/************************************************************/
				/************************************************************/
				/****	ASSESSING THE ECONOMIC CONSEQUENCES OF SECESSION ****/
				/************************************************************/
				/************************************************************/

/*
This analysis departs from a dataset spanning 197 countries (in 2016), covering the period 1940-2016, to provide estimates of the net per capita GDP gain (also called the "independence dividend") of secession. 

The dofiles are structured as follows:
	- Step 1 collects the data, illustrates how various variables are constructed, reports all data sources and provides summary statistics for the main variables used in the subsequent analysis.
	- Step 2 implements a semi-parametric approach to estimate both country-specific and average independence dividends and develops an inferential framework to assess their degree of uncertainty.
	- Step 3 relies on the estimations of part 2 and reports conditional correlations between estimated independence dividends and a number of potential channels.
*/
}

 noisily {
/**********************************************************************************************/
/**********************************************************************************************/
/*********************** Step 1. Data collection & preparation ********************************/
/**********************************************************************************************/
/**********************************************************************************************/

/*
As the synthetic control method exploits the time dimension to produce reliable estimates, we first construct a dataset that covers as much country-years as possible. 
Given our interest in the economic significance of secession, our data pertains to the period 1940-2016 to also be able to include information peratining to the pre-independence period
for the African decolonization process in the 1960s (the earliest secession wave in our sample). As most datasets only start in 1960, we (re)construct data from various sources.
*/

	/*************************************************/
	/*********** Step 1.1. Load raw data *************/
	/*************************************************/
}

		/* 1.1.1. Excell files */
				
			noisily di "Datasets:", _continue
			
			foreach name in "Barlee" "BG" "CLIO" "CLIO_ays" "CLIO_dem" "CLIO_lexpec" "COW_TC" "ER_2" "FHI" "Griffiths" "LIED" "LM" "Madison" "Madison2017" "Madison2018" "P2" "PWT8" "PWT56" "PWT81" "RR" "TED" "UDS" "UN" "UNDP" "VH" "WDI" "WDI_doil"  {
				cd ..
				cd ".\2. Raw data"
				noisily di "`name' ", _continue
				import excel `name'.xlsx, sheet("Data") firstrow
				cd ..
				cd ".\3. Intermediary results"
				save `name'.dta,replace
				clear all
				}
				
			cd ..
			cd ".\2. Raw data"
			noi di "WDI_trade"
			import excel WDI_IE.xlsx, sheet("Data") firstrow clear
			drop if cntrycode_WDI == ""
			cd ..
			cd ".\3. Intermediary results"
			save WDI_trade,replace
			
		/* 1.1.2. CVS files */
				
			* CAIT
			noisily di "CAIT", _continue

				clear all
				cd ..
				cd ".\2. Raw data"
				import delimited ".\CAIT.csv", delimiter(comma) clear   
				rename country cntrycode_CAIT
				rename totalco2emissionsexcludinglandus co2
				cd ..
				cd ".\3. Intermediary results"
				save CAIT.dta, replace
				cd ..
				cd ".\2. Raw data"
				
				
			* COW_SM
			noisily di "COW_SM", _continue

				* Load data
				import delimited ".\COW_SM.csv", clear   
				rename ccode cntrycode_COW_SM
				rename styear independence_year_COW
				rename endyear breakup_year
				keep cntrycode_COW_SM independence_year breakup_year statenme
				cd ..
				cd ".\3. Intermediary results"
				save COW_SM.dta, replace
				cd ..
				cd ".\2. Raw data"
				
			* COW_T
			noisily di "COW_T", _continue

				* Load data
				import delimited ".\COW_T.csv", clear
				keep ccode year imports exports
				rename ccode cntrycode_COW_T
				replace imports = imports*1000000 	// Expressed in millions of current USD
				replace exports = exports*1000000
				rename imports import_COW
				rename exports export_COW
				
				* Express in int'l 1990 $ (GK $)
				cd ..
				cd ".\3. Intermediary results"
				merge m:1 year using ER_2
				drop if _merge == 2
				drop _merge
				
				* Compute deflator for each year
				destring CPI year, replace
				drop Source
				sum year
				foreach year of numlist `r(min)'/`r(max)' {
					sum CPI if year == `year'
					local CPI_`year' = `r(mean)'
					}
				gen ER = .
				replace ER = 1 if year == 1990 // Convert to 1990 dollars, as GDP is expressed in 1990 GK $
				
				sum year
				foreach year of numlist `r(min)'/`r(max)' {
					replace ER = 1*(`CPI_`year''/`CPI_1990') if year == `year'
					}
				drop CPI
			
				* Deflate export & import data
				replace import_COW = import_COW/ER
				replace export_COW = export_COW/ER
				drop ER
				erase ER_2.dta
				cd ..
				cd ".\2. Raw data"
								
				cd ..
				cd ".\3. Intermediary results"
				save COW_T, replace
				cd ..
				cd ".\2. Raw data"
			
			* PRIO
			noisily di "PRIO", _continue

				* Import raw data
				import delimited "PRIO.csv", clear
				keep ccode statename startyear1 endyear1 batdeath
				rename ccode cntrycode_PRIO
		
				* Make unbalaced panel: only include states while they had sovereignty
				gen yearsofwar = endyear1 - startyear1 + 1
				gen avg_yly_bdeaths = batdeath/yearsofwar

				gen helpme = _n
				rename startyear1 Year_1
				rename endyear1 Year_2
				reshape long Year_, i(helpme) j(year)
				drop year
				rename Year_ year
				duplicates drop helpme year, force
				xtset helpme year
				tsfill
				foreach var in cntrycode_PRIO statename batdeath yearsofwar avg_yly_bdeaths {
					bysort helpme (cntrycode_PRIO): replace `var' = `var'[1]
				}
				
				* Keep relevant information
				keep cntrycode_PRIO year avg_yly_bdeaths
				rename avg_yly_bdeaths bdeaths_PRIO
				replace bdeaths_PRIO = . if bdeaths_PRIO <0
				collapse (sum) bdeaths_PRIO, by(cntrycode_PRIO year)
				cd ..
				cd ".\3. Intermediary results"
				save PRIO, replace
				cd ..
				cd ".\2. Raw data"
							
		/* 1.1.3. .dta files */
			
			* AEJ
			noisily di "AEJ", _continue

				clear all
				use AEJ
				noisily di "AEJ", _continue
				rename ifs cntrycode_AEJ
				duplicates drop cntrycode_AEJ year, force
				tsset cntrycode_AEJ year

				* Collect data
				gen dem_AEJ = fhpolrigaug 
				gen dem_AEJ_2 = przdemaug 
				gen dummy_WTO_AEJ = Dummy_WTO_step
				gen dummy_OECD_AEJ = Dummy_OECD_step
				gen dummy_EU_AEJ = Dummy_EU_step

				*Save relevant data
				keep cntrycode_AEJ year dem_AEJ dem_AEJ_2 dummy_WTO_AEJ dummy_OECD_AEJ dummy_EU_AEJ
				cd ..
				cd ".\3. Intermediary results"
				save AEJ.dta, replace
				cd ..
				cd ".\2. Raw data"
				
			* Barro & Lee (2017)
			noisily di "Barlee2017", _continue

				clear all
				use Barlee2017
				rename BLcode cntrycode_barlee2017
				rename yr_sch ays_barlee2017

				*Save relevant data
				keep cntrycode_barlee2017 year ays_barlee2017
				cd ..
				cd ".\3. Intermediary results"
				save Barlee2017.dta, replace
				cd ..
				cd ".\2. Raw data"
				
			* COW_NC
			noisily di "COW_NC", _continue

				clear all
				use COW_NC, clear
				rename ccode cntrycode_COW
				sort cntrycode_COW year
				gen cntrycode_COW_NC = cntrycode_COW
				drop version
				rename tpop pop_COW_NC
				cd ..
				cd ".\3. Intermediary results"
				save COW_NC, replace
				cd ..
				cd ".\2. Raw data"
		
			* GM2
			noisily di "GM2", _continue

				clear all
				use GM2
				rename ccode cntrycode_GM2

				tsset cntrycode_GM2 year

				* Collect relevant data
				gen gdpcap_GM2 = exp(exprgdpols)
				replace gdpcap_GM2 = F.gdpcap_GM2
				gen dem_GM2 = udsmean
				gen dem_GM2_2 = polity2
				gen dummy_oil_GM2 = oil

				*Save relevant data
				keep cntrycode_GM2 year gdpcap_GM2 dem_* dummy_oil_GM2
				cd ..
				cd ".\3. Intermediary results"
				save GM2.dta, replace
				cd ..
				cd ".\2. Raw data"
						
noisily di ""

 noisily {
 /*
 Data sources:
- AEJ: 			Giuliano, Mishra & Spilimbergo (2013) "Democracy and Reforms: Evidence from a New Dataset.",
				available at https://www.aeaweb.org/articles.php?doi=10.1257/mac.5.4.179
- Barlee: 		Barro, R. J. & Lee, J.-W. (1994) "Data Set for a Panel of 138 Countries",
				available at http://admin.nber.org/pub/barro.lee/.
- Barlee2017: 	Barro, R. J. & Lee, J.-W. (1994) "Educational attainment dataset",
				available at http://www.barrolee.com/
- BG			Butcher & Griffiths (2013) "Introducing the International System(s) Dataset (ISD), 1816-2011", International Interactions 39(5)
				available at www.ryan-griffiths.com/s/ISD_Version1_Dissemination.xls
- CAIT: 		CAIT Climate Data Explorer. 2015. Washington, DC: World Resources Institute. 
				Available at http://cait.wri.org
- CLIO*: 		Clio Infra, 
				available at https://www.clio-infra.eu/content/about-clio-infra.
- COW_NC		Correlates of War Project "National Material Capabilities (v5.0)", 
				available at http://www.correlatesofwar.org/data-sets/national-material-capabilities/national-material-capabilities-v4-0
- COW_SM		Correlates of War Project "State System Membership (v2016) ", 
				available at http://www.correlatesofwar.org/data-sets/state-system-membership
- COW_T			Correlates of War Project "National Material Capabilities (v5.0)", 
				available at http://www.correlatesofwar.org/data-sets/national-material-capabilities/national-material-capabilities-v4-0
- COW_TC		Correlates of War Project "Colonial/Dependency Contiguity (v3.1)", 
				available at http://www.correlatesofwar.org/data-sets/colonial-dependency-contiguity
- ER_2			US Department of Labor Statistics "Consumer Price Index (Estimate) 1800-"
				available at https://www.minneapolisfed.org/community/teaching-aids/cpi-calculator-information/consumer-price-index-1800
- LM			Lake & O'Mahony (2004) "The Incredible Shrinking State: Explaining the Territorial Size of Countries", The Journal of Conflict Resolution 48(5)
				available at https://dataverse.harvard.edu/file.xhtml?fileId=656022&version=1.0
- FHI: 			Freedom House "Freedom in the World Country Ratings"
				available at https://freedomhouse.org/sites/default/files/Individual%20Country%20Ratings%20and%20Status%2C%201973-2015%20%28FINAL%29.xls
- GM2: 			Gibler & Miller (2014) "External threat, state capacity and civil war", Conflict Onset dataset
				available at http://file.prio.no/journals/JPR/2014/51/5/Replication%20Gibler%20&%20Miller%202014.zip
- Griffiths:	Griffiths (2015), “Between Dissolution and Blood: How Administrative Lines and Categories Shape Secessionist Outcomes.” International Organization 69(3)
				available at www.ryan-griffiths.com/s/Secessionism_v3.xls
- LIED:			Skaaning, Gerring & Bartusevicius (2015) "A lexical index of electoral democracy"
				available at http://ps.au.dk/fileadmin/Statskundskab/Dokumenter/Forskning/Forskningscentre/DEDERE/lied_v2.xls
- Madison: 		Maddison Project Database, 
				available at http://www.ggdc.net/maddison/maddison-project/data.htm.
- Madison2017: 	Bolt & Van Zanden (2014) "The Maddison Project: Collaborative Research on Historical National Accounts", The Economic History Review, 67 (3)
				available at www.ggdc.net/maddison/maddison-project/data/mpd_2013-01.xlsx.
- Madison2018: 	Bolt, Inklaar, de Jong & Van Zanden (2014) "Maddison Project Database, version 2018"
				available at https://www.rug.nl/ggdc/historicaldevelopment/maddison/data/mpd2018.xlsx
- P2:			The Polity IV Project, 
				available at http://www.systemicpeace.org/inscrdata.html.
- PRIO: 		Lacina & Gleditsch (2005) "Monitoring Trends in Global Combat: A New Dataset of Battle Deaths",
				available at http://www.prio.org/Data/Armed-Conflict/Battle-Deaths/
- PWT56:		Penn World Tables 5.6, 
				available at https://pwt.sas.upenn.edu/php_site/pwt_index.php.
- PWT8:			Penn World Tables 8, 
				available at http://www.rug.nl/research/ggdc/data/pwt/.
- PWT81			Penn World Tables 8.1 "The National Accounts data in current and constant national prices and exchange rate and population data"
				available at http://www.rug.nl/research/ggdc/data/pwt/v81/na_data.xlsx
- RR:			Reinhart & Rogoff (2008) "From Financial Crash to Debt Crisis",
				available at http://www.carmenreinhart.com/data/browse-by-topic/topics/7/
- TED:			Total Economy Database, 
				available at https://www.conference-board.org/data/economydatabase/.
- UDS: 			Melton, Meserve & Pemstein (2010) "Democratic Compromise: A Latent Variable Analysis of Ten Measures of Regime Type"
				available at http://www.unified-democracy-scores.org/files/20140312/z/uds_summary.csv.gz
- UN:			United Nations Population Division (2015)
				available at http://www.un.org/popin/data.html.
- UNDP:			United Nations Development Program (2015)  "Mean Years of Schooling"
				available at http://hdr.undp.org/sites/default/files/103006.xls
- VH:			Vanhanen, T. (2014) " Measures of Democracy 1810-2012 [computer file]. FSD1289, version 6.0", 
				available at http://www.fsd.uta.fi/en/data/catalogue/FSD1289/meF1289e.html.
- WDI:			World Development Indicators (World Bank), 
				available at http://data.worldbank.org/data-catalog/world-development-indicators.
- WDI_IE:		World Development Indicators (World Bank), 
				available at http://data.worldbank.org/data-catalog/world-development-indicators.
*/
}

* Reroute to directory containing dofiles
cd ..
cd ".\1. Dofiles"
}
